<?php
/*--------------------------------------------------------------------------------------------------
    GetSellingUnitReservedQuantityEventInterface.php 2020-3-9
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2016 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

namespace Gambio\Shop\SellingUnit\Database\Unit\Events\Interfaces;


use Gambio\Shop\SellingUnit\Unit\ValueObjects\ReservedQuantity;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\SellingUnitId;
use Psr\EventDispatcher\StoppableEventInterface;

/**
 * interface GetProductReservedQuantityEventInterface
 */
interface GetSellingUnitReservedQuantityEventInterface extends StoppableEventInterface
{
    /**
     * @return SellingUnitId
     */
    public function id(): SellingUnitId;

    /**
     * @return ReservedQuantity|null
     */
    public function quantity(): ?ReservedQuantity;

    /**
     * @param ReservedQuantity $reservedQuantity
     */
    public function setQuantity(ReservedQuantity $reservedQuantity): void;

    public function stop(): void;

}